local colMap = {
	["Amulet"] = "Amulet2_ModsKey",
	["Ring"] = "Ring_ModsKey",
	["Belt"] = "Belt2_ModsKey",
	["Quiver"] = "Quiver_ModsKey",
	["Helmet"] = "Helmet2_ModsKey",
	["Body Armour"] = "BodyArmour2_ModsKey",
	["Boots"] = "Boots2_ModsKey",
	["Gloves"] = "Gloves2_ModsKey",
	["Shield"] = "Shield2_ModsKey",
	["Bow"] = "Bow_ModsKey",
	["Claw"] = "1Hand_ModsKey2",
	["Dagger"] = "1Hand_ModsKey2",
	["Staff"] = "2Hand_ModsKey2",
	["Wand"] = "Wand_ModsKey",
	["One Handed Axe"] = "1Hand_ModsKey2",
	["One Handed Mace"] = "1Hand_ModsKey2",
	["One Handed Sword"] = "1Hand_ModsKey2",
	["Sceptre"] = "1Hand_ModsKey2",
	["Thrusting One Handed Sword"] = "1Hand_ModsKey2",
	["Two Handed Axe"] = "2Hand_ModsKey2",
	["Two Handed Mace"] = "2Hand_ModsKey2",
	["Two Handed Sword"] = "2Hand_ModsKey2",
}
local out = io.open("../Data/3_0/Essence.lua", "w")
out:write('-- This file is automatically generated, do not edit!\n')
out:write('-- Item data (c) Grinding Gear Games\n\nreturn {\n')
for essenceKey = 0, Essences.maxRow do
	local essence = Essences[essenceKey]
	if essence.Tier > 0 then
		local baseItem = BaseItemTypes[essence.BaseItemTypesKey]
		out:write('\t["', baseItem.Id, '"] = { name = "', baseItem.Name, '", ')
		out:write('type = ', essence.EssenceTypeKey, ', tier = ', essence.Tier, ', ')
		out:write('mods = { ')
		for type, col in pairs(colMap) do
			out:write('["', type, '"] = "', Mods[essence[col]].Id, '", ')
		end
		out:write('}, },\n')
	end
end
out:write('}')
out:close()

print("Essences exported.")
